/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.util.IIntervalProvider;
import dev.toma.gunsrpg.util.Interval;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;

public class SurvivalData
implements IQuestData {
    private final int ticks;

    public SurvivalData(IIntervalProvider provider) {
        this.ticks = provider.getTicks();
    }

    public int getTicks() {
        return this.ticks;
    }

    public String toString() {
        return String.format("Survival - Timer: [%s, (%d ticks)]", Interval.format(this.ticks, f -> f.src(Interval.Unit.TICK).out(Interval.Unit.MINUTE, Interval.Unit.SECOND).compact()), this.ticks);
    }

    public static final class Serializer
    implements QuestType.IQuestDataResolver<SurvivalData> {
        @Override
        public SurvivalData resolve(JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            String timeString = JSONUtils.func_151200_h((JsonObject)object, (String)"duration");
            Interval interval = Interval.parse(timeString);
            return new SurvivalData(interval);
        }

        @Override
        public CompoundNBT serialize(SurvivalData data) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("ticks", data.ticks);
            return nbt;
        }

        @Override
        public SurvivalData deserialize(CompoundNBT nbt) {
            return new SurvivalData(() -> nbt.func_74762_e("ticks"));
        }
    }
}

